ORCA/M Asm65816 2.1.0

0001 641D                       TITLE 'ROM Diagnostic Test Sequencer'
0002 641D
0003 641D              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 641D              ;	by EdAsmCvtIIGS version 1.2d7 on 5/14/91 at 7:14:3 PM
0005 641D
0006 641D              ;...............................................................
0007 641D              ;
0008 641D              ; Main entry point to Rom Test Sequencer
0009 641D              ;
0010 641D              ; Call:    In native
0011 641D              ; Return: Not defined
0012 641D              ;
0013 641D              ; Created  : 07 Jan 86 Karl Grabe
0014 641D              ; Alpha 1.0: 17 Feb 86 KRG
0015 641D              ; Alpha 2.0: 10 Mar 86 KRG
0016 641D              ; Beta 1.0 : 26 Mar 86 KRG
0017 641D              ; Beta 2.0 : 23 Apr 86 KRG
0018 641D              ; Beta 3.0 : 14 May 86
0019 641D              ; VER 1.0  : 23 May 86
0020 641D              ;          : 29 Sep 86 FAB Fixed crash in FDB file
0021 641D              ;          :               (INDEX8 MEMORY8 needed)
0022 641D              ; VER 2.0  : 08 Jan 87
0023 641D              ;                        Zero out banks $E0/$E1 at end of 'System Good' 
0024 641D              ;                        On burn-in, diags will run diags continuosly
0025 641D              ;                        and write to NVR if SW0 = low
0026 641D              ;                        Will run Burn-in diags only once and not
0027 641D              ;                        write to NVR if SW0 = high.
0028 641D              ;                        Added Sound diagnostics.
0029 641D              ;
0030 641D              ; VER 2.0  : 05 Feb 87
0031 641D              ;                        Zeroes out banks $E0/$E1 at start of diags.
0032 641D              ;                        In routine BI.SELF.TST changed
0033 641D              ;                           LDA #BI.SELF.MASK to LDA BI.ALT.MASK
0034 641D              ;                           at the request of Singapore.
0035 641D              ;
0036 641D              ;
0037 641D              ; This code determines whether the UUT is in Burn-In or Self test
0038 641D              ; and then executes the selected test. See file: DIAG.MACROS.aii
0039 641D              ; for details.
0040 641D              ;
0041 641D              ;
0042 641D              ;
0043 641D              ;             Copyright Apple Computer Inc. 1986-1987
0044 641D              ;                    All Rights Reserved
0045 641D              ;...............................................................
0046 641D
0047 641D              ST_SEQ_B EQU   *
0048 641D 78                    SEI                            ;o interrupts
0049 641E C2 30                 DATA16                         ;Set 16 bit memory and index
0050 6420
0051 6420
0052 6420              * Code added by FAB to reset all bytes in banks
0053 6420              * E1/E0 from $800 to $BFFF to zero so that
0054 6420              * Control-Open Apple RESET will allow memory
0055 6420              * manager to do a coldstart along with all the
0056 6420              * other tools.
0057 6420              *
0058 6420              * September 30, 1986 by Bachman
0059 6420
0060 6420 A2 00 08              LDX   #$0800                   ;16 bit index from above
0061 6423              @1       EQU   *
0062 6423 9F 00 00 E0           STA   >$E00000,X               ;Zero out from $800 to $BFFF
0063 6427 9F 00 00 E1           STA   >$E10000,X               ; in banks E0 and E1.
0064 642B E8                    INX                            ;;
0065 642C E0 00 C0              CPX   #$C000                   ;Done if at $C000
0066 642F 90 F2                 BCC   @1                       ;Loop til done
0067 6431
0068 6431
0069 6431 A9 01 67              LDA   #TST_DEATH_MGR           ;Test death manager ..
0070 6434 8F 1D 00 E1           STA   >SYSDMGRV+1              ; .. replaces system death manager
0071 6438 E2 30                 DATA8 
0072 643A A9 FF                 LDA   #^TST_DEATH_MGR          ;Bank for test death manager
0073 643C 8F 1F 00 E1           STA   >SYSDMGRV+3              ;Save it
0074 6440 20 FB 66              JSR   BANK_0                   ;Set Data Bank reg = 0
0075 6443 9C 34 C0              STZ   CLOCKCTL                 ;Initialise border color
0076 6446 9C 21 C0              STZ   MONOCOLOR                ;Turn on colour
0077 6449 0E F4 03              ASL   PWREDUP                  ;Destroy powerup byte (cold boot if test interrupted)
0078 644C 9C 2D C0              STZ   SLTROMSEL                ;Enable all internal slots (for Port1 & Disk Port)
0079 644F A9 04                 LDA   #$04                     ;Not too loud ... for speaker beep at end
0080 6451 8D 3C C0              STA   SOUNDCTL                 ;To speaker volume DAC
0081 6454
0082 6454 9C 59 C0              STZ   FAIL_LED                 ;Start by assuming the system is bad
0083 6457 9C E2 C0              STZ   FAIL_LEDD                ;Duplicate FAIL.LED in disk port (CORK FST)
0084 645A 9C 5B C0              STZ   POWER_ON                 ;Tell BI controller NOT to power off!
0085 645D              ;                            ;(... so we don't trash NVR)
0086 645D 9C E4 C0              STZ   POWER_OND                ;Disk port (For FST in Cork)
0087 6460              ;                            ;(for self test: test in progress LED)
0088 6460              ;Find out where we are and do relevant tests ...
0089 6460                       IF SEQ_DEBUG <> 0 THEN         ;For debugging test code use SW2 instead of DIAGTYPE
0090 6460 AD 46 C0              LDA   BI_FLAG                  ;In Burn In ?
0091 6463                       BMI   SELF_TST                 ;We're not in Burn In so do self test
0092 6463                       ELSE 
0093 6463                       LDA   DIAGTYPE                 ;Read Burn In connector if not in debug
0094 6463 10 41                 BPL   SELF_TST                 ;We're not in Burn In so do self test
0095 6465                       ENDIF 
0096 6465 20 CC 66              JSR   RD_BI_NVR_88_66          ;Restore NVR to bank zero ram
0097 6468                       LONGI ON                       	;
0098 6468                       LONGA ON                       	;
0099 6468 AD 0E 03              LDA   CYCLES_MAX               ;Max sequence run per BI power on cycle
0100 646B 8D 21 03              STA   CYCLE_COUNT              ;BI Cycle counter decrements to 0
0101 646E E2 30                 DATA8 
0102 6470 AD 61 C0              LDA   SELF                     ;Self test in Burn In?
0103 6473 30 27                 BMI   BI_SELF_TST              ;Yes .. so self and no wr NVR
0104 6475
0105 6475              NXT_BI_CYCLE EQU   *                    ;Run BI tests again NTV16
0106 6475              ;
0107 6475              ; UUT is in burn in if here.
0108 6475              ; First check if NVR is correctly set by pre bi tester
0109 6475              ; up by checking that the check bytes are intact
0110 6475              ;
0111 6475 C2 30                 DATA16 
0112 6477 9C 1B 03              STZ   BI_FAIL                  ;Zero the fail flag
0113 647A AD 10 03              LDA   VALID_CHK                ;First two (0,1)
0114 647D CF 26 66 FF           CMP   >VALID_MASK              ;Check with what we expect
0115 6481 D0 0E                 BNE   BAD_NVR                  ;Not correct - Stop with self test fail. NVR bad?
0116 6483 AD 11 03              LDA   VALID_CHK+1              ;Last two (1,2)
0117 6486 CF 27 66 FF           CMP   >VALID_MASK+1            ;What we expect
0118 648A D0 05                 BNE   BAD_NVR                  ;Not correct - Stop with self test fail. NVR bad?
0119 648C AD 13 03              LDA   BI_ALT_MASK              ;Mask put there by Pre BI tester in NVR
0120 648F 80 1A                 BRA   EXT_SEQ                  ;Go do the sequence
0121 6491              BAD_NVR  EQU   *                        ;NVR bad or not set up properly
0122 6491 A9 FF FF              LDA   #$FFFF                   ;AA= FF, BB=FF : NVR NOT SETUP
0123 6494 8D 15 03              STA   TST_STATUS               ;Put bad Battery Ram msg on screen.
0124 6497 E2 30                 DATA8 
0125 6499 82 97 00              BRL   FAIL_SELF                ;Goto self test fail routine and die.
0126 649C              BI_SELF_TST EQU   *
0127 649C C2 30                 DATA16                         ;Tests to run in User/Self test
0128 649E 9C 1B 03              STZ   BI_FAIL                  ;Zero fail flag
0129 64A1
0130 64A1              * February 5, 1987    Fern Bachman
0131 64A1              * Changed LDA #BI.SELF.MASK TO LDA BI.ALT.MASK at Singapore's request
0132 64A1 AD 13 03              LDA   BI_ALT_MASK              ;Tests to run in self test when in BI
0133 64A4 80 05                 BRA   EXT_SEQ                  ;Goto sequencer
0134 64A6
0135 64A6              SELF_TST EQU   *
0136 64A6 C2 30                 DATA16 
0137 64A8 A9 FF FF              LDA   #SELF_MASK
0138 64AB
0139 64AB              ;Be of full 16 bit mode if entering here:
0140 64AB              EXT_SEQ  EQU   *                        ;Disk s/w can enter here(c=tests to run)
0141 64AB 8D 1F 03              STA   TST_MASK                 ;Save what tests to run
0142 64AE A9 02 64              LDA   #TST_TAB                 ;Address of top of pointer table
0143 64B1 85 F9                 STA   ZP_PNTR                  ;Use zero page pointer
0144 64B3 AF 02 64 FF           LDA   >TST_TAB                 ;No of bytes in table
0145 64B7 29 FF 00              AND   #$00FF                   ;Drop hi byte
0146 64BA 4A                    LSR   A                        ;Devide by 2 to get number of tests
0147 64BB 8D 23 03              STA   TST_COUNT                ;Save as test counter (decrement)
0148 64BE 8D 25 03              STA   NO_TESTS                 ;Save as number of tests
0149 64C1
0150 64C1              NXT_TST  EQU   *                        ;Do next test
0151 64C1 18                    CLC                            ;Get back to ntv16 (2nd ..)
0152 64C2 FB                    XCE   
0153 64C3 C2 30                 REP   #%00110000
0154 64C5                       LONGA ON
0155 64C5                       LONGI ON
0156 64C5 A2 FF 01              LDX   #$01FF
0157 64C8 9A                    TXS                            ;et up the stack
0158 64C9 9C 29 03              STZ   PORT_ON                  ;Tell ROM.COUT not to write to Port 1
0159 64CC 9C 15 03              STZ   TST_STATUS               ;Zero out all fail status regs
0160 64CF 9C 17 03              STZ   TST_STATUS+2
0161 64D2 E6 F9                 INC   ZP_PNTR                  ;Point to test pointer
0162 64D4 4B                    PHK                            ;t Data bank reg to bank code is running in
0163 64D5 AB                    PLB   
0164 64D6 B2 F9                 LDA   (ZP_PNTR)                ;Get test pointer
0165 64D8 20 FB 66              JSR   BANK_0                   ;Data Bank reg = 0
0166 64DB 85 FB                 STA   TST_PTR                  ;Save it for JMP (TST.PTR) to test
0167 64DD E6 F9                 INC   ZP_PNTR                  ;Increment for next time round
0168 64DF 38                    SEC                            ;ow get NO.TESTS-TST.COUNT to get test we're on
0169 64E0 AD 25 03              LDA   NO_TESTS                 ;Total number of tests n-1
0170 64E3 ED 23 03              SBC   TST_COUNT                ;Current test number
0171 64E6 1A                    INC   A                        ;Bring into range 1 ... n
0172 64E7 8D 15 03              STA   TST_STATUS               ;First byte of status is test number
0173 64EA 22 DB 65 FF           JSL   >DO_TEST                 ;Do/skip (TST.PTR) test ** NATIVE 16 **
0174 64EE 78                    SEI                            ;ke sure interrupts still off
0175 64EF 20 FB 66              JSR   BANK_0                   ;Data Bank reg = 0
0176 64F2 B0 03                 BCS   TST_FAIL                 ;Current test has failed
0177 64F4 82 8A 00              BRL   TEST_PASS
0178 64F7                       EJECT 
0179 64F7              *
0180 64F7              * Test fail handler
0181 64F7              *
0182 64F7              * In Burn-In:
0183 64F7              *    The NVR fail counter and cycle number are incremented
0184 64F7              *    A note is made of the test # that failed + errcodes
0185 64F7              *    The test sequence continues.
0186 64F7              *
0187 64F7              * Self Test:
0188 64F7              *    The test number and fail status is printed on screen:
0189 64F7              *     "AABBCCDD" ( 3 times and staggered ),
0190 64F7              *      where AA is test no and BBCCDD is fail status.
0191 64F7              *
0192 64F7              *    "System Bad: AABBCCDD" message is printed
0193 64F7              *    A high ( 6KHz ) tone is generated.
0194 64F7              *    "AABBCCDD" is sent to serial port 1 at 9600 baud 
0195 64F7              *    The NVR is NOT updated.
0196 64F7              *
0197 64F7
0198 64F7              TST_FAIL EQU   *
0199 64F7 18                    CLC   
0200 64F8 FB                    XCE   
0201 64F9 E2 30                 DATA8 
0202 64FB A9 00                 LDA   #0
0203 64FD 8F 35 C0 E0           STA   $E0C035                  ;Real shadow location
0204 6501 3A                    DEC   A                        ;LDA #$FF
0205 6502 8D 1B 03              STA   BI_FAIL                  ;Set BI.FAIL flag to non zero
0206 6505 20 51 66              JSR   ROM_HOME_86              ;Clr txt page returns in 86
0207 6508 AE 17 03              LDX   TST_STATUS+2             ;Get detailed fail status
0208 650B 8E 02 03              STX   BI_STATUS+2              ;Put fail status aside for NVR later (BI only)
0209 650E AE 15 03              LDX   TST_STATUS               ;Get the test number that failed
0210 6511 8E 00 03              STX   BI_STATUS                ;Save for storage in NVR later (BI only)
0211 6514 E2 10                 IND8 
0212 6516 C2 20                 MEM16 
0213 6518 A9 00 00              LDA   #$0000
0214 651B 38                    SEC   
0215 651C 2A           ROTATE   ROL   A                        ;Set '1' at bit where the test failed
0216 651D CA                    DEX   
0217 651E D0 FC                 BNE   ROTATE
0218 6520 0C 04 03              TSB   BI_FAILMASK              ;Update all tests that failed so far
0219 6523 E2 30                 DATA8 
0220 6525 20 B5 66              JSR   PRINT_STATUS88           ;Put fail status on scrn
0221 6528 9C 59 C0              STZ   FAIL_LED                 ;Tell outside world there's trouble
0222 652B 9C E2 C0              STZ   FAIL_LEDD                ;Disk port also (Corcaig)
0223 652E                       IF SEQ_DEBUG <> 0 THEN         ;Use SW2 or DIAGTYPE? (SW2 for debugging)
0224 652E AD 46 C0              LDA   BI_FLAG                  ;We in BI?
0225 6531                       BPL   FAIL_BI_CONT             ;Yes failed current test but continue .....
0226 6531                       ELSE 
0227 6531                       LDA   DIAGTYPE                 ;We in BI?
0228 6531 30 4E                 BMI   FAIL_BI_CONT             ;Yes failed current test but continue .....
0229 6533                       ENDIF 
0230 6533
0231 6533              ;If here then UUT has failed self test
0232 6533 A2 00        FAIL_SELF LDX   #0
0233 6535 9C 27 03              STZ   CUR                      ;Set curser to zero
0234 6538 9C 5A C0              STZ   POWER_OFF                ;For LED on Game IO or disk port
0235 653B 9C E5 C0              STZ   POWER_OFFD               ;Disk port phase (agus Corcaig)
0236 653E                                                      ; SEG	RUNBANK	;Tell assembler bank $FF for bad message
0237 653E BF 74 65 FF  NXT_FAIL_CHAR LDA   >FAIL_SELF_MSG,X
0238 6542 F0 05                 BEQ   FAIL_SELF_TONE           ;Check for end of msg
0239 6544 20 72 66              JSR   ROM_COUT88               ;Print "System Bad message"
0240 6547 80 F5                 BRA   NXT_FAIL_CHAR            ;For all characters
0241 6549              FAIL_SELF_TONE EQU   *
0242 6549 A9 FF                 LDA   #$FF                     ;Non zero
0243 654B 8D 1D 03              STA   |ST_FAIL                 ;Make a note that a fail occurred.
0244 654E 20 B5 66              JSR   PRINT_STATUS88           ;Print stagered on screen
0245 6551 20 18 67              JSR   INIT_PORT1               ;Setup Port 1 for writing (Cork's process)
0246 6554 A9 FF                 LDA   #$FF                     ;Non zero
0247 6556 8D 29 03              STA   |PORT_ON                 ;Enable port1
0248 6559 20 B5 66              JSR   PRINT_STATUS88           ;Print to Port 1
0249 655C A9 8D                 LDA   #$8D                     ;CR
0250 655E 20 5F 67              JSR   COUT_PORT1               ;Send Carrage Return to port 1
0251 6561 A9 8A                 LDA   #$8A                     ;LF
0252 6563 20 5F 67              JSR   COUT_PORT1               ;And a line feed
0253 6566 18                    CLC                            ;Make sure we're still in native mode
0254 6567 FB                    XCE   
0255 6568 E2 30                 DATA8 
0256 656A C2 10                 IND16 
0257 656C A2 10 27              LDX   #10000                   ;No of cycles
0258 656F A9 05                 LDA   #5                       ;Period for 6 KHz or so
0259 6571 82 BC 00              BRL   TONE86                   ;Go do tone and die.
0260 6574              FAIL_SELF_MSG EQU   *
0261 6574 A0 D3 F9 F3           DC B:' System Bad:'
0262 6580 00                    DC B:$00
0263 6581                                                      ; SEG	$00
0264 6581                       EJECT 
0265 6581              *
0266 6581              *
0267 6581              * Test returns here even if test was skipped
0268 6581              *         -- OR --
0269 6581              * if test failed AND UUT is in BI.
0270 6581              *
0271 6581              * Note: carry is clear ('passed') when test skipped
0272 6581              *
0273 6581              FAIL_BI_CONT EQU   *                    ;Failed test but in BI so continue
0274 6581              TEST_PASS EQU   *                       ;Passed test in BI or Self Test so continue
0275 6581 18                    CLC                            ;In case test ended up in emulation mode
0276 6582 FB                    XCE   
0277 6583 E2 30                 DATA8 
0278 6585 A9 00                 LDA   #0                       ;Turn on all shadowing
0279 6587 8F 35 C0 E0           STA   $E0C035                  ;Real shadow location
0280 658B 20 B5 66              JSR   PRINT_STATUS88           ;Show user tests progressing
0281 658E CE 23 03              DEC   TST_COUNT                ;Decrement single byte counter
0282 6591 30 03                 BMI   END_TST_SEQ              ;All tests done
0283 6593 82 2B FF              BRL   NXT_TST                  ;Do another test if TST.COUNT not zero
0284 6596              END_TST_SEQ EQU   *
0285 6596                       IF SEQ_DEBUG <> 0 THEN         ;Test SW2 or DIAGTYPE for BI
0286 6596 AD 46 C0              LDA   BI_FLAG                  ;In BI?
0287 6599                       BMI   PASS_SELF_STOP88         ;No so unit has passed self test
0288 6599                       ELSE 
0289 6599                       LDA   DIAGTYPE                 ;In BI?
0290 6599 10 5D                 BPL   PASS_SELF_STOP88         ;No so unit has passed self test
0291 659B                       ENDIF 
0292 659B AD 1B 03              LDA   BI_FAIL                  ;Check if any test failed
0293 659E 30 28                 BMI   BI_CYCLE_FAIL            ;Yes so handle it
0294 65A0 9C 58 C0              STZ   PASS_LED                 ;Last cycle passed all tests
0295 65A3 9C E3 C0              STZ   PASS_LEDD                ;Disk port also
0296 65A6 C2 30                 DATA16 
0297 65A8 EE 08 03              INC   BI_PASSES                ;Record as a passed cycle
0298 65AB              CONT_CYC EQU   *
0299 65AB EE 06 03              INC   BI_COUNTER               ;Cumulative counter for ENTIRE time in BI
0300 65AE CE 21 03              DEC   CYCLE_COUNT              ;Reset to CYCLES.MAX on each BI power up
0301 65B1 F0 03                 BEQ   FIN_CYCLES               ;All BI test cycles complete
0302 65B3 82 BF FE              BRL   NXT_BI_CYCLE             ;Continue doing BI cycles
0303 65B6
0304 65B6              ;Required no of BI cycles complete so stop and wait
0305 65B6              FIN_CYCLES EQU   *
0306 65B6 20 E1 66              JSR   WR_BI_NVR_66_88          ;Save counters status to NVR for next time or tester
0307 65B9                       LONGI OFF
0308 65B9                       LONGA OFF
0309 65B9 9C 5A C0              STZ   POWER_OFF                ;Tell BI controller it's ok to power down.
0310 65BC 9C E5 C0              STZ   POWER_OFFD               ; .. And Cork FST controller via disk port
0311 65BF
0312 65BF
0313 65BF              * Modified by FAB
0314 65BF              * Singapore requested the burn in self diagnostic
0315 65BF              * run continuously with no write to batteryram if
0316 65BF              * SW0 (SELF same as BUTN0) is 1 ('-').
0317 65BF              * September 30, 1986 by Bachman
0318 65BF
0319 65BF AD 61 C0              LDA   SELF                     ;If active ('-') then loop continuously
0320 65C2 10 03                 BPL   @1                       ;If inactive ('+') then stop the processor
0321 65C4 82 56 FE              BRL   ST_SEQ_B                 ;Loop and restart diagnostics
0322 65C7
0323 65C7              @1       EQU   *
0324 65C7 DB                    STP                            ;Just hang til power off
0325 65C8
0326 65C8
0327 65C8              BI_CYCLE_FAIL EQU   *                   ;Here if a cycle has failed a test
0328 65C8 C2 30                 DATA16 
0329 65CA              ;INC BI.FAILS  ;No more, replaced by BI.FIRSTF
0330 65CA AD 06 03              LDA   BI_COUNTER
0331 65CD 8D 0C 03              STA   BI_LASTF                 ;Record what cycle failure occurred
0332 65D0 AE 0A 03              LDX   BI_FIRSTF                ;Is this the firt time it fails?
0333 65D3 D0 03                 BNE   @2                       ;No
0334 65D5 8D 0A 03              STA   BI_FIRSTF                ;Yes, record the first fail cycle
0335 65D8 80 D1        @2       BRA   CONT_CYC                 ;Go on to next cycle if necessary
0336 65DA
0337 65DA 6B           TST_RTS  RTL                            ;ny rts instruction
0338 65DB
0339 65DB                                                      ; SEG	RUNBANK	;All tests are normally in Bank $FF
0340 65DB              DO_TEST  EQU   *                        ; ** Native 16 **
0341 65DB                                                      ; SEG	$00	;Data and softswitches in Bank $00
0342 65DB 9C 1D 03              STZ   ST_FAIL                  ;Clear test fail status to pass
0343 65DE 6E 1F 03              ROR   TST_MASK                 ;Put test 0/1 in carry, 16 bit.
0344 65E1 90 F7                 BCC   TST_RTS                  ;Skip this test  *** Note carry CLR => passed ***
0345 65E3 E2 30                 DATA8 
0346 65E5 EE 34 C0              INC   |CLOCKCTL                ;Each test has a new border color
0347 65E8                       IF SEQ_DEBUG <> 0 THEN 
0348 65E8 20 51 66              JSR   TEMP_WAIT                ;Slow down display while debugging only
0349 65EB                       ENDIF 
0350 65EB                       JSR   ROM_HOME_86              ;Routine sets 86 (8bit memory, 16 bit index)
0351 65EB E2 30                 DATA8 
0352 65ED 20 B5 66              JSR   PRINT_STATUS88           ;Prt tst running (useful if test crashes)
0353 65F0 A9 80                 LDA   #%10000000               	;Hurry things along a little
0354 65F2 8D 36 C0              STA   CYAREG
0355 65F5 6C FB 00              JMP   (TST_PTR)                ;Go do test ** MEM8 IND8 ** Return with RTL
0356 65F8                       EJECT 
0357 65F8              ****************************************************************
0358 65F8              *
0359 65F8              * All following Subroutines are MEMORY8 & INDEX16
0360 65F8              * (subname)86
0361 65F8              * KG JAN 86
0362 65F8              *
0363 65F8              ****************************************************************
0364 65F8
0365 65F8              ;...............................................................
0366 65F8              ; PASS.SELF.STOP88
0367 65F8              ; UUT passed self test so put out 1Khz
0368 65F8              ; tone, print message & stop
0369 65F8              ;
0370 65F8              ; MEMX, INDX
0371 65F8              ;...............................................................
0372 65F8              PASS_SELF_STOP88 EQU   *
0373 65F8 20 51 66              JSR   ROM_HOME_86              ;Routine sets 86
0374 65FB E2 30                 DATA8 
0375 65FD 9C 58 C0              STZ   PASS_LED                 ;Tell game IO we've passed
0376 6600 9C E3 C0              STZ   PASS_LEDD                ;And disk port
0377 6603 9C 5A C0              STZ   POWER_OFF                ;Tell game IO test finished
0378 6606 9C E5 C0              STZ   POWER_OFFD               ;And disk port
0379 6609 A2 00                 LDX   #0
0380 660B 9C 27 03              STZ   CUR
0381 660E                                                      ; SEG	RUNBANK	;Tell assembler where code resides
0382 660E BF 19 66 FF  NXT_PASS_CHAR LDA   >SELF_PASS_MSG,X
0383 6612 F0 15                 BEQ   PASS_SELF_TONE           ;Check for end of msg
0384 6614 20 72 66              JSR   ROM_COUT88               ;Print "System Good message"
0385 6617 80 F5                 BRA   NXT_PASS_CHAR
0386 6619              SELF_PASS_MSG EQU   *
0387 6619 A0 D3 F9 F3           DC B:' System Good'
0388 6625 00                    DC B:$00
0389 6626 CB D2 C7     VALID_MASK DC B:'KRG'                   ;Do not change - used in NVR by tst s/w
0390 6629                                                      ; SEG	$00
0391 6629              PASS_SELF_TONE EQU   *
0392 6629 C2 10                 IND16 
0393 662B A2 E8 03              LDX   #1000                    ;Number of speaker clicks
0394 662E A9 11                 LDA   #17                      ;Period for 1KHz
0395 6630
0396 6630              ;...............................................................
0397 6630              ; TONE86
0398 6630              ; Generate tone Period: ACC (8)
0399 6630              ;               Cycles: X (16)
0400 6630              ;
0401 6630              ; Enter MEM8,IND16
0402 6630              ; Ret :Does not return
0403 6630              ;...............................................................
0404 6630              TONE86   EQU   *
0405 6630 A8                    TAY   
0406 6631 98           NXT_KICK TYA                            ; GET DURATION
0407 6632 20 A8 FC              JSR   $FCA8                    ; MONITOR WAIT ROUTINE
0408 6635 2C 30 C0              BIT   SPKR
0409 6638 CA                    DEX   
0410 6639 D0 F6                 BNE   NXT_KICK
0411 663B
0412 663B
0413 663B AD 1D 03              LDA   ST_FAIL                  ;Has self test failed?
0414 663E F0 01                 BEQ   END_SELF                 ;Wait for OA pressed to Repeat Self Test
0415 6640 DB                    STP                            ;Die here with Self Test err msg on screen
0416 6641              END_SELF EQU   *
0417 6641              * ASL SELF
0418 6641              * BCC END.SELF  ;Wait here 'till Open apple pressed
0419 6641 0E 46 C0              ASL   DIAGTYPE                 ;Test if in burn-in or user diags
0420 6644 AD 61 C0              LDA   SELF                     ;Get Open-Apple status
0421 6647 B0 03                 BCS   CHKOAONLY                ;If in burn-in diags check Open-Apple only
0422 6649 2D 62 C0              AND   BUTN1                    ; else both buttons pressed to continue?
0423 664C              CHKOAONLY EQU   *
0424 664C 10 F3                 BPL   END_SELF                 ;If '+' in any case then keep looping
0425 664E 82 CC FD              BRL   ST_SEQ_B                 ;Go to very beginning of diags again.
0426 6651
0427 6651              ;...............................................................
0428 6651              ;
0429 6651              ;ROM.HOME.86
0430 6651              ;Clear the text page & set to 40 text
0431 6651              ;
0432 6651              ; Enter/RET Native
0433 6651              ; Exit Mem8 Ind16
0434 6651              ;...............................................................
0435 6651              ROM_HOME_86 EQU   *
0436 6651 C2 10                 IND16                          ;Index regs 16 bit
0437 6653 E2 20                 MEM8                           ;For soft switch toggles
0438 6655 9C 00 C0              STZ   CLR80COL
0439 6658 9C 0C C0              STZ   CLR80VID                 ;40 COL
0440 665B 9C 51 C0              STZ   TXTSET                   ;Get out of graphics
0441 665E 9C 54 C0              STZ   TXTPAGE1
0442 6661 A9 01                 LDA   #1
0443 6663 8D 29 C0              STA   NEWVIDEO                 ;Make sure not in new video mode
0444 6666 A0 00 04              LDY   #LINE1                   ;The text screen
0445 6669 A9 A0                 LDA   #' '                     ;Space
0446 666B              ROM_NXT_SP EQU   *                      ;Write another space
0447 666B 99 00 04              STA   LINE1,Y                  ;The text screen
0448 666E 88                    DEY   
0449 666F 10 FA                 BPL   ROM_NXT_SP
0450 6671 60                    RTS   
0451 6672                       EJECT 
0452 6672              ****************************************************************
0453 6672              *
0454 6672              * All following subroutines are MEMORY8 & INDEX8
0455 6672              * (subname)88
0456 6672              *
0457 6672              ****************************************************************
0458 6672
0459 6672              ;...............................................................
0460 6672              ;
0461 6672              ; ROM.COUT88
0462 6672              ; Print char on last line of screen. 40 col only.
0463 6672              ; offset by CUR. (CUR <40 !)
0464 6672              ; The caller must make sure the 'curser' does not
0465 6672              ; end up outside the text window!
0466 6672              ;
0467 6672              ; If ST.FAIL is true then print staggered fail status on scrn
0468 6672              ; If PORT.ON is true then send fail status to port 1
0469 6672              ;
0470 6672              ; Enter/RET: DATA8
0471 6672              ;...............................................................
0472 6672 E2 30        ROM_COUT88 DATA8 
0473 6674 AE 27 03              LDX   CUR                      ;Get curser
0474 6677 9D D0 07              STA   LINE1+$3D0,X
0475 667A AE 1D 03              LDX   ST_FAIL                  ;For self test fail only
0476 667D E0 00                 CPX   #0
0477 667F F0 18                 BEQ   NOT_FAIL
0478 6681              ;Fail status so print on screen in different posn
0479 6681              ;and send to port 1
0480 6681 AE 27 03              LDX   CUR                      ;Restore curser
0481 6684 9D F1 03              STA   LINE1-$0F,X              ;Top lhs of scrn
0482 6687 9D 72 04              STA   LINE1+$81-$0F,X          ;Next line shift one to right
0483 668A 9D F3 04              STA   LINE1+$102-$0F,X         ;Nxt line, one to right
0484 668D AE 29 03              LDX   PORT_ON                  ;Check do we write to port1 also ?
0485 6690 E0 00                 CPX   #0
0486 6692 F0 05                 BEQ   NOT_FAIL                 ;No so don' write to port 1
0487 6694 20 5F 67              JSR   COUT_PORT1               ;Send Acc to port
0488 6697 18                    CLC                            ;Make sure we're still in native mode
0489 6698 FB                    XCE   
0490 6699              NOT_FAIL EQU   *
0491 6699 AE 27 03              LDX   CUR                      ;
0492 669C EE 27 03              INC   CUR                      ;Increment curser
0493 669F 60                    RTS   
0494 66A0
0495 66A0              ;...............................................................
0496 66A0              ; ROM.PRBYTE88    ( Accumulator )
0497 66A0              ; Print a byte on screen at CUR
0498 66A0              ; Enter/Ret DATA8
0499 66A0              ;...............................................................
0500 66A0              ROM_PRBYTE88 EQU   *
0501 66A0 48                    PHA                            ;ave byte to prt
0502 66A1 6A                    ROR   A
0503 66A2 6A                    ROR   A
0504 66A3 6A                    ROR   A
0505 66A4 6A                    ROR   A                        ;Get hi nybble into low nyb posn
0506 66A5 20 A9 66              JSR   PRNYBBLE                 ;go prt nybble
0507 66A8 68                    PLA                            ;ow work on low nybble
0508 66A9 29 0F        PRNYBBLE AND   #$0F                     ;Strip out hi nybble
0509 66AB C9 0A                 CMP   #$0A
0510 66AD 90 02                 BLT   PR_NOADD
0511 66AF 69 06                 ADC   #$06
0512 66B1              PR_NOADD EQU   *
0513 66B1 69 B0                 ADC   #$B0
0514 66B3 80 BD                 BRA   ROM_COUT88
0515 66B5
0516 66B5              ;...............................................................
0517 66B5              ; PRINT.STATUS88
0518 66B5              ; Print 6 byte status on text scrn.
0519 66B5              ;
0520 66B5              ; Enter/Ret DATA8
0521 66B5              ;...............................................................
0522 66B5              PRINT_STATUS88 EQU   *
0523 66B5 A9 0F                 LDA   #15
0524 66B7 8D 27 03              STA   CUR                      ;Set up curser
0525 66BA A0 00                 LDY   #0
0526 66BC 5A                    PHY                            ;ave Y when using ROM.PRBYTE
0527 66BD              NXT_STAT EQU   *
0528 66BD B9 15 03              LDA   TST_STATUS,Y             ;Get the byte
0529 66C0 20 A0 66              JSR   ROM_PRBYTE88             ;Y gets trashed
0530 66C3 7A                    PLY                            ;estore byte count
0531 66C4 C8                    INY                            ;xt byte
0532 66C5 5A                    PHY   
0533 66C6 C0 04                 CPY   #4
0534 66C8 D0 F3                 BNE   NXT_STAT                 ;Next status byte
0535 66CA 7A                    PLY   
0536 66CB 60                    RTS   
0537 66CC                       EJECT 
0538 66CC              ;
0539 66CC              ;...............................................................
0540 66CC              ; RD.BI.NVR.88.66
0541 66CC              ; Read NVR counters to ram for BI cycling
0542 66CC              ;
0543 66CC              ; NTV DATA 8
0544 66CC              ;................................................................
0545 66CC              RD_BI_NVR_88_66 EQU   *
0546 66CC              MVN_NVR  EQU   NVR_FREE                 ;Lower 2 bytes of BRAMBUFFER adr (free bat space)
0547 66CC E2 30                 DATA8 
0548 66CE 22 84 00 E1           JSL   >TOREADBR                ;Read NVR to bank ^BRAMBUFFER (=$E1)
0549 66D2 C2 30                 DATA16 
0550 66D4 A2 61 03              LDX   #MVN_NVR                 ;Source addess
0551 66D7 A0 00 03              LDY   #BI_STATUS               ;Destination address
0552 66DA A9 15 00              LDA   #NVR_END-NVR_BEG         ;Number of bytes to move
0553 66DD 54 00 E1              MVN   BRAMBUFFER,$000000
0554 66E0 60                    RTS                            ;;
0555 66E1
0556 66E1              ;...............................................................
0557 66E1              ; WR.BI.NVR.66.88
0558 66E1              ; Write BRAMBUFFER to NVR
0559 66E1              ;
0560 66E1              ; NTV DATA 8
0561 66E1              ;................................................................
0562 66E1              WR_BI_NVR_66_88 EQU   *
0563 66E1 A2 00 03              LDX   #BI_STATUS               ;From (Bank $00)
0564 66E4 A0 61 03              LDY   #MVN_NVR                 ;To   (Bank $E1)
0565 66E7 A9 15 00              LDA   #NVR_END-NVR_BEG         ;Number of bytes to move
0566 66EA 54 E1 00              MVN   $000000,BRAMBUFFER       ;Move status bytes to bank $E1
0567 66ED E2 30                 DATA8 
0568 66EF AD 61 C0              LDA   SELF                     ;Are we in BI but running Self Diags?
0569 66F2 30 04                 BMI   BI_SLF_NVR               ;Yes so don't write to NVR
0570 66F4 22 80 00 E1           JSL   >TOWRITEBR               ;Write stuff permanently to BRAM
0571 66F8 E2 30        BI_SLF_NVR DATA8 
0572 66FA 60                    RTS                            ;;
0573 66FB
0574 66FB              ;...............................................................
0575 66FB              ; BANK.0   XX/XX
0576 66FB              ; Set Data bank register to zero
0577 66FB              ;
0578 66FB              ;...............................................................
0579 66FB
0580 66FB              BANK_0   EQU   *
0581 66FB F4 00 00              PEA   0
0582 66FE AB                    PLB   
0583 66FF AB                    PLB                            ;et it
0584 6700 60                    RTS   
0585 6701              ;...............................................................
0586 6701              ; TST.DEATH.MGR
0587 6701              ; This routine replaces the system death manager during tests.
0588 6701              ; SYSDMGRV vector points to here.
0589 6701              ;
0590 6701              ;...............................................................
0591 6701
0592 6701                                                      ; SEG	RUNBANK	;Bank this code is in
0593 6701              TST_DEATH_MGR EQU   *
0594 6701 18                    CLC   
0595 6702 FB                    XCE                            ;E = 0 (Native mode)
0596 6703 C2 30                 REP   #%00110000
0597 6705                       LONGA ON
0598 6705                       LONGI ON
0599 6705 A2 FF 01              LDX   #$01FF
0600 6708 9A                    TXS                            ;eset stack pointer
0601 6709 20 FB 66              JSR   BANK_0                   ;Make sure Data Bank is zero
0602 670C A9 00 00              LDA   #0
0603 670F 5B                    TCD                            ;irect register
0604 6710 1A                    INC   A                        ;Errcode 01
0605 6711 8F 18 03 00           STA   >TST_STATUS+3            ;DD=01: Death manager was called during test
0606 6715 82 DF FD              BRL   TST_FAIL                 ;Print/save test that was running
0607 6718                       TITLE 'Setup & write to Port 1'
0608 6718              ;...............................................................
0609 6718              ; COUT.PORT1  8/8
0610 6718              ; Output Fail status registers to serial device
0611 6718              ; using Pascal 1.1 entry points.
0612 6718              ;
0613 6718              ; Two entry Points:
0614 6718              ; INIT.PORT1 -> Initialise port for writing
0615 6718              ; COUT.PORT1 -> Send 8 bit acc to port1
0616 6718              ;
0617 6718              ;
0618 6718              ; 22 Jan 86:  KG  Created
0619 6718              ; 20 Mar 86:  KG  Port to Bank $FF ROM
0620 6718              ;...............................................................
0621 6718
0622 6718                                                      ; SEG	RUNBANK	;Bank code resides in
0623 6718              INIT_PORT1 EQU   *
0624 6718                       LONGA OFF
0625 6718                       LONGI OFF
0626 6718 A9 04                 LDA   #$04
0627 671A 8D 68 C0              STA   |STATEREG                ;Correct language card setup
0628 671D
0629 671D              ;
0630 671D              ; Set up Port 1 Parameters
0631 671D              ;
0632 671D              ; Copy PORT.PARMS to BRAMBUFFER ( in bank $E1 )
0633 671D              ; Then a Pascal Init call will use these parms
0634 671D              ; instead of those in the Control Panel.
0635 671D              ;
0636 671D
0637 671D A2 0C                 LDX   #END_PORT_PARMS-PORT_PARMS ;All of port 1 parameters
0638 671F              STO_NXT_PARM EQU   *                    ;Store next parameter
0639 671F BF 68 67 FF           LDA   >PORT_PARMS,X            ;Get it from table
0640 6723 9F C0 02 E1           STA   >BRAMBUFFER,X            ;Save it in BRAMBUFFER
0641 6727 CA                    DEX   
0642 6728 10 F5                 BPL   STO_NXT_PARM             ;Do next parameter
0643 672A
0644 672A              ; Release $C800 space
0645 672A A9 C1                 LDA   #>SLOT_ADDR
0646 672C 8D F8 07              STA   |$07F8                   ;For interrupts 
0647 672F AD FF CF              LDA   |CLRROM                  ;Disable C800
0648 6732
0649 6732              ; Setup Init pointer
0650 6732 AD 0D C1              LDA   |INIT_OFF                ;Offset byte for Pascal Init
0651 6735 85 10                 STA   INIT_JMP                 ;Points to actual init address
0652 6737 A9 C1                 LDA   #>INIT_OFF
0653 6739 85 11                 STA   INIT_JMP+1               ;Contains actual Init address
0654 673B
0655 673B              ; Setup write pointer
0656 673B AD 0F C1              LDA   |WRITE_OFF               ;Offset byte for Pascal Write
0657 673E 85 12                 STA   WRITE_JMP
0658 6740 A9 C1                 LDA   #>WRITE_OFF
0659 6742 85 13                 STA   WRITE_JMP+1              ;Contains actual Write address
0660 6744
0661 6744              ; Relocate section of Bank $FF code to bank zero
0662 6744 A9 0E                 LDA   #BANK_ZERO_END-BANK_ZERO_BEG ;No of bytes to transfer
0663 6746 AA                    TAX                            ;se y as byte loop counter
0664 6747              NXT_ZBYTE EQU   *
0665 6747 BF 74 67 FF           LDA   >BANK_ZERO_BEG,X         ;Load it from bank $ff rom
0666 674B 9D 00 20              STA   |SER_ZBANK,X             ;Save it in zero bank
0667 674E CA                    DEX                            ;ove down a byte
0668 674F 10 F6                 BPL   NXT_ZBYTE                ;Repeat
0669 6751 A2 C1                 LDX   #>SLOT_ADDR              ;X & X must have slot related values
0670 6753 A0 10                 LDY   #SLOT*16
0671 6755
0672 6755              ; Initialise Port 1. Use Pascal 1.1 protocol
0673 6755              DO_INIT  EQU   *
0674 6755 22 00 20 00           JSL   >SER_ZBANK               ;Go initialise device for writing
0675 6759
0676 6759 A9 AA                 LDA   #'*'
0677 675B 20 5F 67              JSR   COUT_PORT1               ;Tell tester failcode is sent next
0678 675E 60                    RTS                            ;o sequencer
0679 675F
0680 675F              COUT_PORT1 EQU   *                      ; send acc to port
0681 675F A2 C1                 LDX   #>SLOT_ADDR
0682 6761 A0 10                 LDY   #SLOT*16
0683 6763              DO_WRITE EQU   *                        ;Write Acc to slot
0684 6763 22 07 20 00           JSL   >SER_ZBANK+ZERO_WRITE-ZERO_INIT ;To bank zero routine
0685 6767 60                    RTS                            ;;
0686 6768
0687 6768
0688 6768              PORT_PARMS EQU   *                      ;Port Parms (default values except baud)
0689 6768
0690 6768 00                    DC B:$00                       ;This port is a: Printer
0691 6769 00                    DC B:$00                       ;Line Length: Unlimited
0692 676A 00                    DC B:$00                       ;Delete First LF after CR: No
0693 676B 01                    DC B:$01                       ;Add LF after CR: Yes
0694 676C 00                    DC B:$00                       ;Echo: No
0695 676D 00                    DC B:$00                       ;Buffering: No
0696 676E 07                    DC B:$07                       ;Baud: 1200  ** Non Default **
0697 676F 06                    DC B:$06                       ;Data/Stop Bits: 8/1
0698 6770 02                    DC B:$02                       ;Parity: None
0699 6771 01                    DC B:$01                       ;DCD Handshake: Yes
0700 6772 01                    DC B:$01                       ;DSR Handshake: Yes
0701 6773 00                    DC B:$00                       ;XON/XOFF Handshake: No
0702 6774              END_PORT_PARMS EQU   *
0703 6774
0704 6774                       EJECT 
0705 6774              ;
0706 6774              ; The next section of code is downloaded to bank zero RAM
0707 6774              ; and run from there. (Because we cannot call the Port
0708 6774              ; firmware with a JSL)
0709 6774              ;
0710 6774
0711 6774                                                      ; SEG	RUNBANK
0712 6774              BANK_ZERO_BEG EQU   *                   ;Beginning of Bank zero image
0713 6774                                                      ; SEG	$00
0714 6774              ZERO_INIT EQU   *                       ;Initialise from bank zero
0715 6774 20 04 20              JSR   SER_ZBANK+IJ-ZERO_INIT   ;Go through INIT.JMP vector in bank $00
0716 6777 6B                    RTL                            ;eturn to bank sequencer RUNBANK
0717 6778 6C 10 00     IJ       JMP   (INIT_JMP)               ;Jump to $00/C1XX space
0718 677B
0719 677B              ZERO_WRITE EQU   *                      ;Write Acc form bank zero
0720 677B 20 0B 20              JSR   SER_ZBANK+WJ-ZERO_INIT   ;Go through WRITE.JMP vector
0721 677E 6B                    RTL                            ;eturn to sequencer RUNBANK
0722 677F 6C 12 00     WJ       JMP   (WRITE_JMP)              ;Jump to $00/C1XX space
0723 6782              BANK_ZERO_END EQU   *                   ;End of Bank zero image
